/*---------------------------------------------------------------*/

#include "typesiigs.r"

/*------------------- Values used through out -------------------*/

#define MainWindow $2000
#define ButtonWindow $2001
#define StatTextWindow $2002
#define LineEditWindow $2003
#define PictureWindow $2004
#define PopUpWindow $2005
#define TextEditWindow $2006
#define ListWindow $2007
#define Prog1Window $2008
#define Prog2Window $2009
#define Prog3Window $200A
#define Prog4Window $200B
#define Prog5Window $200C
#define Prog6Window $200D

#define ButButtons $0001
#define ButStatText $0002
#define ButLineEdit $0003
#define ButPictures $0004
#define ButPopUps $0005
#define ButTextEdit $0006
#define ButLists $0007
#define ButProg1 $0008
#define ButProg2 $0009
#define ButProg3 $000A
#define ButProg4 $000B
#define ButProg5 $000C
#define ButProg6 $000D
#define MainText $000E

#define AboutBusyAlert 1
#define BusyBoxStartup 1



/*----------------------- About Box ------------------------------*/
resource rAlertString (AboutBusyAlert) {
 "0\$19\$00\$A0\$00\$AA\$00\$E0\$01"
 "0/"
 TBCenterJust
 TBStyleOutline
 "Busy Box"
 TBEndOfLine
 TBStylePlain
 "A sample program to demonstrate the new features of the Apple IIGS toolbox."
 TBEndOfLine
 TBEndOfLine
 "by"
 TBEndOfLine
 "Steven E. Glass"
 TBEndOfLine
 TBEndOfLine
 "Copyright Apple Computer, Inc."
 TBEndOfLine
 "All Rights Reserved"
 TBEndOfLine
 "Version 3.0/^#6\$00"
};






/*----------------------Startup Record ---------------------------*/
resource rToolStartup (BusyBoxStartup) {
 mode640, /* master SCB */
 {
        3,$0300,  /* misc tools */
        4,$0301,  /* quickdraw */
        5,$0302,  /* desk manager */
        6,$0300,  /* eventMgr */
/*      7,$0200,  /* scheduler */
/*      8,$0301,  /* sound tools */
/*      9,$0201,  /* ADB tools */
/*      10,$0202, /* SANE */
        11,$0200, /* int math */
        14,$0301, /* Window Manager */
        15,$0301, /* Menu Manager */
        16,$0301, /* Control Manager */
        18,$0301, /* QD Aux */
        19,$0300, /* print manager */
        20,$0301, /* LineEdit tool set */
        21,$0302, /* Dialog Manager */
        22,$0300, /* Scrap manager */
        23,$0301, /* standard file */
/*      25,$0104, /* NoteSynth */
/*      26,$0104, /* Note Seq */
        27,$0301, /* Font manager */
        28,$0301, /* list manager */
/*      29,$0101, /* ACE */
/*      32,$0103, /* Midi Tools */
        34,$0101  /* text edit */
 }
};




/*---------------------------------------------------------------------------*/
/*
/* Main Window
/*
/* This is the template for the main window with all the buttons that lead
/* to other buttons.
/*
/*---------------------------------------------------------------------------*/
resource rWindParam1 (MainWindow) {
 fTitle+fVis, /* Frame Bits */
 MainWindow, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {0,0}, /* data size */
 {0,0}, /* max height-width */
 {0,0}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {40,90,180,550}, /* window Position */
 infront, /* wPlane */
 MainWindow, /* Control Ref */
 refIsResource*0x0100+resourceToResource /* descriptor */
};

/*---------------------------------------------------------------------------*/
/* This is the title of the main window
/*---------------------------------------------------------------------------*/
resource rPString (MainWindow) {
 "Busy Box"
 };



/*---------------------------------------------------------------------------*/
/* The following define the controls for the main window.
/* First I start with some constants.
/*---------------------------------------------------------------------------*/

#define ButWidth 140
#define ButHeight 12
#define ButSep 8
#define ButVSep 5

#define TopOfRow1 50
#define BottomOfRow1 TopOfRow1+ButHeight
#define TopOfRow2 BottomOfRow1+ButVSep
#define BottomOfRow2 TopOfRow2+ButHeight
#define TopOfRow3 BottomOfRow2+ButVSep
#define BottomOfRow3 TopOfRow3+ButHeight
#define TopOfRow4 BottomOfRow3+ButVSep+ButVSep
#define BottomOfRow4 TopOfRow4+ButHeight
#define TopOfRow5 BottomOfRow4+ButVSep
#define BottomOfRow5 TopOfRow5+ButHeight

#define LeftEdge1 ButSep
#define RightEdge1 LeftEdge1+ButWidth
#define LeftEdge2 RightEdge1+ButSep
#define RightEdge2 LeftEdge2+ButWidth
#define LeftEdge3 RightEdge2+ButSep
#define RightEdge3 LeftEdge3+ButWidth


/* List of all controls in Main Window */

resource rControlList (MainWindow) {
 {
 ButButtons,
 ButStatText,
 ButLineEdit,
 ButPictures,
 ButPopUps,
 ButTextEdit,
 ButLists,
 ButProg1,
 ButProg2,
 ButProg3,
 ButProg4,
 ButProg5,
 ButProg6,
 MainText
 };
};

resource rControlTemplate (MainText) {
 MainText, /* control ID */
 {2,4,42,456}, /* control rectangle */
 EditTextControl{{ /* control type */
 0x0000, /* flag */
 fCtlCanBeTarget+fCtlWantsEvents+fctlProcNotPtr, /* more flags */
 0, /* ref con */
 fReadOnly+fDrawBounds, /* text flags */
 {0xFFFF,0xFFFF,0xFFFF,0xFFFF}, /* indent rect */
 0xFFFFFFFF, /* Vert Bar */
 0, /* Vert Amount */
 0, /* hor bar */
 0, /* hor Amount */
 0, /* style ref */
 dataIsTextBlock+RefIsResource*8, /* text descriptor */
 MainText, /* text ref */
 0 /* text size (not used) */


 }};
};


/* The static text for main window */
resource rText (MainText) {
 "The new toolbox makes it much easier to write programs for the Apple IIGS. "
 TBEndOfLine
 TBEndOfLine
 "This program is incredibly simple. "
 TBEndOfLine
 TBEndOfLine
 "Press one of the round buttons "
 "to find out about the new kinds of controls that are supported. "
 TBEndOfLine
 TBEndOfLine
 "Press one of the square "
 "buttons to see the code for this program."
};

/* The definition of the buttons button */
resource rControlTemplate (ButButtons) {
 ButButtons, /* control ID */
 {TopOfRow1,LeftEdge1,BottomOfRow1,RightEdge1}, /* control rect */
 SimpleButtonControl{{ /* control type */
 0, /* flag */
 0x1002, /* more flags */
 0, /* ref con */
 ButButtons /* title ref */
 }};
};

resource rpString (ButButtons) {
 "Buttons..."
};

/* the Static Text Button */
resource rControlTemplate (ButStatText) {
 ButStatText, /* control id */
 {TopOfRow1,LeftEdge2,BottomOfRow1,RightEdge2}, /* control rect */
 SimpleButtonControl{{ /* control type */
 0, /* flag */
 0x1002, /* more flags */
 0, /* ref con */
 ButStatText /* title ref */
 }};
};

resource rpString (ButStatText) {
 "Static Text..."
};

/* The Line Edit button. */
resource rControlTemplate (ButLineEdit) {
 ButLineEdit, /* control ID */
 {TopOfRow1,LeftEdge3,BottomOfRow1,RightEdge3}, /* control rect */
 SimpleButtonControl{{ /* control type */
 0, /* flag */
 0x1002, /* more flags */
 0, /* ref con */
 ButLineEdit /* title ref */
 }};
};

resource rpString (ButLineEdit) {
 "Line Edit..."
};

/* the pictures button */
resource rControlTemplate (ButPictures) {
 ButPictures, /* control ID */
 {TopOfRow2,LeftEdge1,BottomOfRow2,RightEdge1}, /* control rect */
 SimpleButtonControl{{ /* button type */
 0, /* flag */
 0x1002, /* more flags */
 0, /* ref con */
 ButPictures /* title ref */
 }};
};

resource rpString (ButPictures) {
 "Pictures..."
};


/* The pop-ups button */
resource rControlTemplate (ButPopUps) {
 ButPopUps, /* control ID */
 {TopOfRow2,LeftEdge2,BottomOfRow2,RightEdge2}, /* control rect */
 SimpleButtonControl{{ /* control type */
 0, /* flag */
 0x3002, /* more flags */
 0, /* ref con */
 ButPopUps /* title ref */
 }};
};

resource rpString (ButPopUps) {
 "Pop-up Menus..."
};


/* the text edit button */
resource rControlTemplate (ButTextEdit) {
 ButTextEdit, /* control ID */
 {TopOfRow2,LeftEdge3,BottomOfRow2,RightEdge3}, /* control rect */
 SimpleButtonControl{{ /* control type */
 0, /* flag */
 0x1002, /* more flags */
 0, /* ref con */
 ButTextEdit /* title ref */
 }};
};

resource rpString (ButTextEdit) {
 "Text Edit..."
};


/* the lists button */
resource rControlTemplate (ButLists) {
 ButLists, /* control ID */
 {TopOfRow3,LeftEdge2,BottomOfRow3,RightEdge2}, /* control rect */
 SimpleButtonControl{{ /* control type */
 0, /* flag */
 0x3002, /* more flags */
 0, /* ref con */
 ButLists /* title ref */
 }};
};

resource rpString (ButLists) {
 "Lists..."
};


/* the main program button */
resource rControlTemplate (ButProg1) {
 ButProg1, /* control ID */
 {TopOfRow4,LeftEdge1,BottomOfRow4,RightEdge1}, /* control rect */
 SimpleButtonControl{{ /* control type */
 SquareButton, /* flag */
 0x3002, /* more flags */
 0, /* ref con */
 ButProg1 /* title ref */
 }};
};

resource rpString (ButProg1) {
 "Main Program..."
};

/* the main program button */
resource rControlTemplate (ButProg2) {
 ButProg2, /* control ID */
 {TopOfRow4,LeftEdge2,BottomOfRow4,RightEdge2}, /* control rect */
 SimpleButtonControl{{ /* control type */
 SquareButton, /* flag */
 0x3002, /* more flags */
 0, /* ref con */
 ButProg2 /* title ref */
 }};
};

resource rpString (ButProg2) {
 "Events..."
};

/* the main program button */
resource rControlTemplate (ButProg3) {
 ButProg3, /* control ID */
 {TopOfRow4,LeftEdge3,BottomOfRow4,RightEdge3}, /* control rect */
 SimpleButtonControl{{ /* control type */
 SquareButton, /* flag */
 0x3002, /* more flags */
 0, /* ref con */
 ButProg3 /* title ref */
 }};
};

resource rpString (ButProg3) {
 "Menus..."
};

/* the main program button */
resource rControlTemplate (ButProg4) {
 ButProg4, /* control ID */
 {TopOfRow5,LeftEdge1,BottomOfRow5,RightEdge1}, /* control rect */
 SimpleButtonControl{{ /* control type */
 SquareButton, /* flag */
 0x3002, /* more flags */
 0, /* ref con */
 ButProg4 /* title ref */
 }};
};

resource rpString (ButProg4) {
 "Windows..."
};

/* the main program button */
resource rControlTemplate (ButProg5) {
 ButProg5, /* control ID */
 {TopOfRow5,LeftEdge2,BottomOfRow5,RightEdge2}, /* control rect */
 SimpleButtonControl{{ /* control type */
 SquareButton, /* flag */
 0x3002, /* more flags */
 0, /* ref con */
 ButProg5 /* title ref */
 }};
};

resource rpString (ButProg5) {
 "Utilities..."
};

/* the main program button */
resource rControlTemplate (ButProg6) {
 ButProg6, /* control ID */
 {TopOfRow5,LeftEdge3,BottomOfRow5,RightEdge3}, /* control rect */
 SimpleButtonControl{{ /* control type */
 SquareButton, /* flag */
 0x3002, /* more flags */
 0, /* ref con */
 ButProg6 /* title ref */
 }};
};

resource rpString (ButProg6) {
 "Globals..."
};





/*---------------------------------------------------------------------------*/
/*
/* Buttons...
/*
/* The List window uses ID's in the $3000 range.
/*
/*---------------------------------------------------------------------------*/

#define ButtonTextID $3001
#define But1 $3101
#define But2 $3102
#define But3 $3103
#define But4 $3104
#define Check1 $3105
#define Check2 $3106
#define Check3 $3107
#define Check4 $3108
#define Radio1 $3109
#define Radio2 $310A
#define Radio3 $310B
#define Radio4 $310C
#define Icon1 $310D
#define Icon2 $310E




#define BLine1 50
#define BLine2 BLine1+18
#define BLine3 BLine2+18
#define BLine4 BLine3+18


resource rWindParam1 (ButtonWindow) {
 fTitle+fMove+fZoom+fGrow+fBScroll+fRScroll+fClose, /* Frame Bits */
 ButtonWindow, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {400,640}, /* data size */
 {200,640}, /* max height-width */
 {1,1}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {50,50,120,260}, /* window Position */
 infront, /* wPlane */
 ButtonWindow, /* Control Ref */
 refIsResource*0x0100+resourceToResource /* descriptor */
};



resource rpString (ButtonWindow) {
 "Buttons Window"
};


resource rControlList (ButtonWindow) {
 {
 ButtonTextID,
 But1,
 But2,
 But3,
 But4,
 Check1,
 Check2,
 Check3,
 Check4,
 Radio1,
 Radio2,
 Radio3,
 Radio4,
 Icon1,
 Icon2
 };
};

/* Template for static text in main window */
resource rControlTemplate (ButtonTextID) {
 ButtonTextID, /* control ID */
 {2,4,48,460}, /* control rectangle */
 StatTextControl{{ /* control type */
 0xFF00, /* flag */
 0x1002, /* more flags */
 0, /* ref con */
 ButtonTextID /* title ref */
 }};
};

/* The static text for list window */
resource rTextForLETextBox2 (ButtonTextID) {
 "There are four types of buttons: simple buttons, check boxes, radio buttons and "
 "Icon Buttons. Each button can have its own keyboard equivalent. All tracking and "
 "hiliting is handled by TaskMaster."
};

resource rControlTemplate (But1) {
 But1, /* control ID */
 {BLine1,LeftEdge1,0,0}, /* control rect */
 SimpleButtonControl{{ /* control type */
 NormalButton, /* flag */
 fctlProcNotPtr+fCtlWantsEvents+RefIsResource, /* more flags */
 0, /* ref con */
 But1, /* title ref */
 0, /* color table not used */
 {"A","a",0,0} /* key equiv */
 }};
};

resource rpString (But1) {
 "Normal Button (A)"
};


resource rControlTemplate (But2) {
 But2, /* control ID */
 {BLine2,LeftEdge1,0,0}, /* control rect */
 SimpleButtonControl{{ /* control type */
 DefaultButton, /* flag */
 fctlProcNotPtr+fCtlWantsEvents+RefIsResource, /* more flags */
 0, /* ref con */
 But2, /* title ref */
 0, /* color table not used */
 {"B","b",0,0} /* key equiv */
 }};
};

resource rpString (But2) {
 "Default Button (B)"
};


resource rControlTemplate (But3) {
 But3, /* control ID */
 {BLine3,LeftEdge1,0,0}, /* control rect */
 SimpleButtonControl{{ /* control type */
 SquareButton, /* flag */
 fctlProcNotPtr+fCtlWantsEvents+RefIsResource, /* more flags */
 0, /* ref con */
 But3, /* title ref */
 0, /* color table not used */
 {"C","c",0,0} /* key equiv */
 }};
};

resource rpString (But3) {
 "Square Button (C)"
};


resource rControlTemplate (But4) {
 But4, /* control ID */
 {BLine4,LeftEdge1,0,0}, /* control rect */
 SimpleButtonControl{{ /* control type */
 SquareShadowButton, /* flag */
 fctlProcNotPtr+fCtlWantsEvents+RefIsResource, /* more flags */
 0, /* ref con */
 But4, /* title ref */
 0, /* color table not used */
 {"D","d",0,0} /* key equiv */
 }};
};

resource rpString (But4) {
 "Square Shadow Button (D)"
};

resource rControlTemplate (Check1) {
 Check1, /* control ID */
 {BLine1,LeftEdge3,0,0}, /* control rect */
 CheckControl{{ /* control type */
 0, /* flag */
 fctlProcNotPtr+fCtlWantsEvents+RefIsResource, /* more flags */
 0, /* ref con */
 Check1, /* title ref */
 1, /* initial value */
 0, /* color table not used */
 {"e","E",0,0} /* key equiv */
 }};
};

resource rpString (Check1) {
 "Check One (E)"
};

resource rControlTemplate (Check2) {
 Check2, /* control ID */
 {BLine1+10,LeftEdge3,0,0}, /* control rect */
 CheckControl{{ /* control type */
 0, /* flag */
 fctlProcNotPtr+fCtlWantsEvents+RefIsResource, /* more flags */
 0, /* ref con */
 Check2, /* title ref */
 1, /* initial value */
 0, /* color table not used */
 {"f","F",0,0} /* key equiv */
 }};
};

resource rpString (Check2) {
 "Check Two (F)"
};

resource rControlTemplate (Check3) {
 Check3, /* control ID */
 {BLine1+20,LeftEdge3,0,0}, /* control rect */
 CheckControl{{ /* control type */
 0, /* flag */
 fctlProcNotPtr+fCtlWantsEvents+RefIsResource, /* more flags */
 0, /* ref con */
 Check3, /* title ref */
 0, /* initial value */
 0, /* color table not used */
 {"G","g",0,0} /* key equiv */
 }};
};

resource rpString (Check3) {
 "Check Three (G)"
};

resource rControlTemplate (Check4) {
 Check4, /* control ID */
 {BLine1+30,LeftEdge3,0,0}, /* control rect */
 CheckControl{{ /* control type */
 0, /* flag */
 fctlProcNotPtr+fCtlWantsEvents+RefIsResource, /* more flags */
 0, /* ref con */
 Check4, /* title ref */
 1, /* initial value */
 0, /* color table not used */
 {"H","h",0,0} /* key equiv */
 }};
};

resource rpString (Check4) {
 "Check Four (H)"
};

resource rControlTemplate (Radio1) {
 Radio1, /* control ID */
 {BLine4,LeftEdge3,0,0}, /* control rect */
 RadioControl{{ /* control type */
 0, /* flag */
 fctlProcNotPtr+fCtlWantsEvents+RefIsResource, /* more flags */
 0, /* ref con */
 Radio1, /* title ref */
 0, /* initial value */
 0, /* color table not used */
 {"i","I",0,0} /* key equiv */
 }};
};

resource rpString (Radio1) {
 "Radio One (I)"
};

resource rControlTemplate (Radio2) {
 Radio2, /* control ID */
 {BLine4+10,LeftEdge3,0,0}, /* control rect */
 RadioControl{{ /* control type */
 0, /* flag */
 fctlProcNotPtr+fCtlWantsEvents+RefIsResource, /* more flags */
 0, /* ref con */
 Radio2, /* title ref */
 1, /* initial value */
 0, /* color table not used */
 {"J","j",0,0} /* key equiv */
 }};
};

resource rpString (Radio2) {
 "Radio Two (J)"
};

resource rControlTemplate (Radio3) {
 Radio3, /* control ID */
 {BLine4+20,LeftEdge3,0,0}, /* control rect */
 RadioControl{{ /* control type */
 0, /* flag */
 fctlProcNotPtr+fCtlWantsEvents+RefIsResource, /* more flags */
 0, /* ref con */
 Radio3, /* title ref */
 0, /* initial value */
 0, /* color table not used */
 {"K","k",0,0} /* key equiv */
 }};
};

resource rpString (Radio3) {
 "Radio Three (K)"
};

resource rControlTemplate (Radio4) {
 Radio4, /* control ID */
 {BLine4+30,LeftEdge3,0,0}, /* control rect */
 RadioControl{{ /* control type */
 0, /* flag */
 fctlProcNotPtr+fCtlWantsEvents+RefIsResource, /* more flags */
 0, /* ref con */
 Radio4, /* title ref */
 0, /* initial value */
 0, /* color table not used */
 {"L","l",0,0} /* key equiv */
 }};
};

resource rpString (Radio4) {
 "Radio Four (L)"
};


resource rControlTemplate (Icon1) {
 Icon1, /* control ID */
 {BLine4+20,LeftEdge1,BLine4+20+40,LeftEdge1+100}, /* control rect */
 IconButtonControl{{ /* control type */
 SquareButton, /* flag */
 fctlProcNotPtr+fCtlWantsEvents+RefIsResource+RefIsResource*$0010, /* more flags */
 0, /* ref con */
 Icon1, /* Icon Ref */
 Icon1, /* title ref */
 0, /* color table not used */
 0, /* display mode */
 {"M","m",0,0}	/* key equiv */
 }};
};

resource rpString (Icon1) {
 "Icon One (M)"
};

resource rIcon (Icon1) {
 0x8000, /* Kind */
 20, /* Height */
 28, /* Width */

 $"FFFFFFFFFFF00000FFFFFFFFFFFF"
 $"FFFFFFFF000ddddd000FFFFFFFFF"
 $"FFFFFF0088888dddddd00FFFFFFF"
 $"FFFFF0d888888d888dd8d0FFFFFF"
 $"FFFF08888888dd888dd8880FFFFF"
 $"FFFF08888888dd88dd88880FFFFF"
 $"FFF08888888dddddddd88880FFFF"
 $"FFF08888888dddddddddd8d0FFFF"
 $"FF0d8d88dd8ddddddd8888880FFF"
 $"FF0d8d88dd8dddddd88888880FFF"
 $"FF0dddd8ddddddddd88888880FFF"
 $"FF0dd88888ddddddd88888880FFF"
 $"FFF08888888dddddd8888880FFFF"
 $"FFF08888888ddddddd888880FFFF"
 $"FFFF0888888dddddddd8880FFFFF"
 $"FFFF088888ddddddddd8880FFFFF"
 $"FFFFF08888ddddddddd880FFFFFF"
 $"FFFFFF008dddddddddd00FFFFFFF"
 $"FFFFFFFF000ddddd000FFFFFFFFF"
 $"FFFFFFFFFFF00000FFFFFFFFFFFF",

 $"00000000000FFFFF000000000000"
 $"00000000FFFFFFFFFFF000000000"
 $"000000FFFFFFFFFFFFFFF0000000"
 $"00000FFFFFFFFFFFFFFFFF000000"
 $"0000FFFFFFFFFFFFFFFFFFF00000"
 $"0000FFFFFFFFFFFFFFFFFFF00000"
 $"000FFFFFFFFFFFFFFFFFFFFF0000"
 $"000FFFFFFFFFFFFFFFFFFFFF0000"
 $"00FFFFFFFFFFFFFFFFFFFFFFF000"
 $"00FFFFFFFFFFFFFFFFFFFFFFF000"
 $"00FFFFFFFFFFFFFFFFFFFFFFF000"
 $"00FFFFFFFFFFFFFFFFFFFFFFF000"
 $"000FFFFFFFFFFFFFFFFFFFFF0000"
 $"000FFFFFFFFFFFFFFFFFFFFF0000"
 $"0000FFFFFFFFFFFFFFFFFFF00000"
 $"0000FFFFFFFFFFFFFFFFFFF00000"
 $"00000FFFFFFFFFFFFFFFFF000000"
 $"000000FFFFFFFFFFFFFFF0000000"
 $"00000000FFFFFFFFFFF000000000"
 $"00000000000FFFFF000000000000";
};


resource rControlTemplate (Icon2) {
 Icon2, /* control ID */
 {BLine4+20,LeftEdge2,BLine4+20+40,LeftEdge2+100}, /* control rect */
 IconButtonControl{{ /* control type */
 SquareButton, /* flag */
 fctlProcNotPtr+fCtlWantsEvents+RefIsResource+RefIsResource*$0010, /* more flags */
 0, /* ref con */
 Icon2, /* Icon Ref */
 Icon2, /* title ref */
 0, /* color table not used */
 0, /* display mode */
 {"N","n",0,0}	/* key equiv */
 }};
};

resource rpString (Icon2) {
 "Icon Two (N)"
};

resource rIcon (Icon2) {
 0x8000, /* Kind */
 20, /* Height */
 28, /* Width */

 $"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
 $"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
 $"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
 $"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
 $"FFFFFFFFFF0FFFFFFFFFDFFFFFFF"
 $"FFFFFFFFF00FFFFFFFEFFDFFFFFF"
 $"FFFFFFFF0F0FFFFFAFFEFFDFFFFF"
 $"FFFFFFF0FF0FF7FFAFFEFFDFFFFF"
 $"FF00000FFF0FFF7FFAFFEFFDFFFF"
 $"F0FFFF0FFF0FFF7FFAFFEFFDFFFF"
 $"F0FFFF0FFF0FFF7FFAFFEFFDFFFF"
 $"F0FFFF0FFF0FFF7FFAFFEFFDFFFF"
 $"FF00000FFF0FFF7FFAFFEFFDFFFF"
 $"FFFFFFF0FF0FF7FFAFFEFFDFFFFF"
 $"FFFFFFFF0F0FFFFFAFFEFFDFFFFF"
 $"FFFFFFFFF00FFFFFFFEFFDFFFFFF"
 $"FFFFFFFFFF0FFFFFFFFFDFFFFFFF"
 $"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
 $"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
 $"FFFFFFFFFFFFFFFFFFFFFFFFFFFF",

 $"0000000000000000000000000000"
 $"0000000000000000000000000000"
 $"0000000000000000000000000000"
 $"0000000000000000000000000000"
 $"0000000000F000000000F0000000"
 $"000000000FF0000000F00F000000"
 $"00000000FFF00000F00F00F00000"
 $"0000000FFFF00F00F00F00F00000"
 $"00FFFFFFFFF000F00F00F00F0000"
 $"0FFFFFFFFFF000F00F00F00F0000"
 $"0FFFFFFFFFF000F00F00F00F0000"
 $"0FFFFFFFFFF000F00F00F00F0000"
 $"00FFFFFFFFF000F00F00F00F0000"
 $"0000000FFFF00F00F00F00F00000"
 $"00000000FFF00000F00F00F00000"
 $"000000000FF0000000F00F000000"
 $"0000000000F000000000F0000000"
 $"0000000000000000000000000000"
 $"0000000000000000000000000000"
 $"0000000000000000000000000000";



};

/*---------------------------------------------------------------------------*/
/*
/* StatText...
/*
/* The StatText window uses ID's in the $4000 range.
/*
/*---------------------------------------------------------------------------*/

#define StatTextTextID $4001

resource rWindParam1 (StatTextWindow) {
 fTitle+fMove+fZoom+fGrow+fBScroll+fRScroll+fClose, /* Frame Bits */
 StatTextWindow, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {400,640}, /* data size */
 {200,640}, /* max height-width */
 {1,1}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {50,50,120,260}, /* window Position */
 infront, /* wPlane */
 StatTextWindow, /* Control Ref */
 refIsResource*0x0100+resourceToResource /* descriptor */
};



resource rpString (StatTextWindow) {
 "Static Text Window"
};


resource rControlList (StatTextWindow) {
 {
 StatTextTextID
 };
};

/* Template for static text in main window */
resource rControlTemplate (StatTextTextID) {
 StatTextTextID, /* control ID */
 {2,4,200,560}, /* control rectangle */
 StatTextControl{{ /* control type */
 0xFF00+fSubstituteText, /* flag */
 fctlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 StatTextTextID /* title ref */
 }};
};

/* The static text for list window */
resource rTextForLETextBox2 (StatTextTextID) {
 "Static text is a simple but powerful control that lets you put pre-defined text "
 "in a window. The text is drawn with LETextBox2 so you can format the text any "
 "way you want: using special "
 TBStyleOutline
 "styles"
 TBStylePlain
 ", "
 TBFont
 TBVenice
 "\$00\$0E"
 "fonts"
 TBFont
 TBShaston
 "\$00\$08"
 ", "
 TBForeColor
 TBColor5
 "colors"
 TBForeColor
 TBColor0
 ","
 TBEndOfLine
 TBRightJust
 "indenting or justification. "
 TBEndOfLine
 TBLeftJust
 TBEndOfLine
 "An additional feature of static text is substitutions. You may substitute up "
 "to ten strings into your ""static"" text, making it not so static. The ## and ** "
 "symbols are used to indicate substitutions. You use ##n to indicate a built in string. "
 "You use **n to indicate a particular string of your own. The SetCtlParamPtr call lets "
 "you set up the substitution array that should be used."
 TBEndOfLine
 TBEndOfLine
 "The built in strings are"
 TBEndOfLine
 TBEndOfLine
 TBLeftMargin
 "\$20\$00"
 "##0 is #0"
 TBEndOfLine
 "##1 is ""#1"""
 TBEndOfLine
 "##2 is ""#2"""
 TBEndOfLine
 "##3 is ""#3"""
 TBEndOfLine
 "##4 is ""#4"""
 TBEndOfLine
 "##5 is ""#5"""
 TBEndOfLine
 "##6 is ""#6"""
 TBEndOfLine
};

/*---------------------------------------------------------------------------*/
/*
/* LineEdit...
/*
/* The List window uses ID's in the $5000 range.
/*
/*---------------------------------------------------------------------------*/

#define LineEditTextID $5001
#define LineEdit1 $5002
#define LineEdit2 $5003
#define LineEdit3 $5004
#define LineEdit4 $5005
#define LineEdit5 $5006
#define LineEdit6 $5007


#define LELine1 80
#define LELine2 100
#define LELine3 120
#define LELeft1 10
#define LEWidth 200
#define LEHeight 13
#define LELeft2 220

resource rWindParam1 (LineEditWindow) {
 fTitle+fMove+fZoom+fGrow+fBScroll+fRScroll+fClose, /* Frame Bits */
 LineEditWindow, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {400,640}, /* data size */
 {200,640}, /* max height-width */
 {1,1}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {50,50,120,260}, /* window Position */
 infront, /* wPlane */
 LineEditWindow, /* Control Ref */
 refIsResource*0x0100+resourceToResource /* descriptor */
};



resource rpString (LineEditWindow) {
 "Line Edit Window"
};


resource rControlList (LineEditWindow) {
 {
 LineEditTextID,
 LineEdit6,
 LineEdit5,
 LineEdit4,
 LineEdit3,
 LineEdit2,
 LineEdit1
 };
};


resource rControlTemplate (LineEditTextID) {
 LineEditTextID, /* control ID */
 {2,4,52,460}, /* control rectangle */
 EditTextControl{{ /* control type */
 0x0000, /* flag */
 fCtlCanBeTarget+fCtlWantsEvents+fctlProcNotPtr, /* more flags */
 0, /* ref con */
 fReadOnly+fDrawBounds+fTabSwitch, /* text flags */
 {0xFFFF,0xFFFF,0xFFFF,0xFFFF}, /* indent rect */
 0xFFFFFFFF, /* Vert Bar */
 0, /* Vert Amount */
 0, /* hor bar */
 0, /* hor Amount */
 0, /* style ref */
 dataIsTextBlock+RefIsResource*8, /* text descriptor */
 LineEditTextID, /* text ref */
 0 /* text length */

 }};
};






/* The static text for list window */
resource rText (LineEditTextID) {
 "The following six line edit fields are all defined in resources. All the "
 "typing, mouse tracking and tabbing is handled by the toolbox. The application "
 "does not have to do anything until it wants to read what is in the fields. Note, the "
 "fifth item is set up to work as a password item. The characters you type are not echoed "
 "but they are collected correctly."
};


resource rControlTemplate (LineEdit1) {
 0, /* control ID */
 {LELine1,LELeft1,LELine1+LEHeight,LELeft1+LEWidth}, /* control rectangle */
 EditLineControl{{ /* control type */
 0, /* Flag */
 fctlProcNotPtr+RefIsResource, /* More Flags */
 0, /* ref con */
 40, /* Max Length */
 LineEdit1 /* Initial Value Ref */
 }};
};

resource rPString (LineEdit1) {
 "First Line Edit Item"
 };

resource rControlTemplate (LineEdit2) {
 0, /* control ID */
 {LELine1,LELeft2,LELine1+LEHeight,LELeft2+LEWidth}, /* control rectangle */
 EditLineControl{{ /* control type */
 0, /* Flag */
 fctlProcNotPtr+RefIsResource, /* More Flags */
 0, /* ref con */
 40, /* Max Length */
 LineEdit2 /* Initial Value Ref */
 }};
};

resource rPString (LineEdit2) {
 "Second Line Edit Item"
 };


resource rControlTemplate (LineEdit3) {
 0, /* control ID */
 {LELine2,LELeft1,LELine2+LEHeight,LELeft1+LEWidth }, /* control rectangle */
 EditLineControl{{ /* control type */
 0, /* Flag */
 fctlProcNotPtr+RefIsResource, /* More Flags */
 0, /* ref con */
 40, /* Max Length */
 LineEdit3 /* Initial Value Ref */
 }};
};

resource rPString (LineEdit3) {
 "Third Line Edit Item"
 };


resource rControlTemplate (LineEdit4) {
 0, /* control ID */
 {LELine2,LELeft2,LELine2+LEHeight,LELeft2+LEWidth}, /* control rectangle */
 EditLineControl{{ /* control type */
 0, /* Flag */
 fctlProcNotPtr+RefIsResource, /* More Flags */
 0, /* ref con */
 40, /* Max Length */
 LineEdit4 /* Initial Value Ref */
 }};
};

resource rPString (LineEdit4) {
 "Fourth Line Edit Item"
 };


resource rControlTemplate (LineEdit5) {
 0, /* control ID */
 {LELine3,LELeft1,LELine3+LEHeight,LELeft1+LEWidth}, /* control rectangle */
 EditLineControl{{ /* control type */
 0, /* Flag */
 fctlProcNotPtr+RefIsResource, /* More Flags */
 0, /* ref con */
 40+$8000, /* Max Length */
 LineEdit5 /* Initial Value Ref */
 }};
};

resource rPString (LineEdit5) {
 "Fifth Line Edit Item"
 };


resource rControlTemplate (LineEdit6) {
 0, /* control ID */
 {LELine3,LELeft2,LELine3+LEHeight,LELeft2+LEWidth}, /* control rectangle */
 EditLineControl{{ /* control type */
 0, /* Flag */
 fctlProcNotPtr+RefIsResource, /* More Flags */
 0, /* ref con */
 40, /* Max Length */
 LineEdit6 /* Initial Value Ref */
 }};
};

resource rPString (LineEdit6) {
 "Sixth Line Edit Item"
 };







/*---------------------------------------------------------------------------*/
/*
/* Pictures...
/*
/* The List window uses ID's in the $6000 range.
/*
/*---------------------------------------------------------------------------*/

#define PictureTextID $6001
#define Pic1 $6002

resource rWindParam1 (PictureWindow) {
 fTitle+fMove+fZoom+fGrow+fBScroll+fRScroll+fClose, /* Frame Bits */
 PictureWindow, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {400,640}, /* data size */
 {200,640}, /* max height-width */
 {1,1}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {50,50,120,260}, /* window Position */
 infront, /* wPlane */
 PictureWindow, /* Control Ref */
 refIsResource*0x0100+resourceToResource /* descriptor */
};



resource rpString (PictureWindow) {
 "Pictures Window"
};


resource rControlList (PictureWindow) {
 {
 PictureTextID,
 Pic1
 };
};

/* Template for static text in main window */
resource rControlTemplate (PictureTextID) {
 PictureTextID, /* control ID */
 {2,4,48,460}, /* control rectangle */
 StatTextControl{{ /* control type */
 0xFF00, /* flag */
 0x1002, /* more flags */
 0, /* ref con */
 PictureTextID /* title ref */
 }};
};

/* The static text for list window */
resource rTextForLETextBox2 (PictureTextID) {
 "You can also make picture controls. Pictures are collections of QuickDraw "
 "commands that are all drawn at once. They can contain most any drawing command "
 "including text, color, and special fonts."
};


resource rControlTemplate (Pic1) {
 Pic1, /* control ID */
 {50,2,150,202}, /* control rectangle */
 PictureControl{{ /* control type */
 0xFF00, /* flag */
 0x1002, /* more flags */
 0, /* ref con */
 Pic1 /* title ref */
 }};
};

data rPicture (Pic1) {
 $"80 00 00 00 00 00 8F 00 38 01 11 82 01 00 0A 00" /* A.....e.8..C.... */
 $"01 C0 01 C0 FF 3F FF 3F 51 00 05 00 0A 00 8A 00" /* .?.?.?.?Q.....a. */
 $"2E 01 53 00 0A 00 14 00 85 00 24 01 53 00 0F 00" /* ..S.....O.$.S... */
 $"1E 00 80 00 1A 01 53 00 14 00 28 00 7B 00 10 01" /* ..A...S...(.{... */
 $"53 00 19 00 32 00 76 00 06 01 53 00 1E 00 3C 00" /* S...2.v...S...<. */
 $"71 00 FC 00 53 00 23 00 46 00 6C 00 F2 00 53 00" /* q...S.#.F.l...S. */
 $"28 00 50 00 67 00 E8 00 53 00 2D 00 5A 00 62 00" /* (.P.g...S.-.Z.b. */
 $"DE 00" /* .. */
};



/*---------------------------------------------------------------------------*/
/*
/* PopUps...
/*
/* The List window uses ID's in the $7000 range.
/*
/*---------------------------------------------------------------------------*/

#define PopUpTextID $7001
#define PopUp1 $7100
#define PopUp2 $7200
#define PopUp1Item1 $7101
#define PopUp1Item2 $7102
#define PopUp1Item3 $7103
#define PopUp2Item1 $7201
#define PopUp2Item2 $7202
#define PopUp2Item3 $7203
#define PopUp2Item4 $7204
#define PopUp2Item5 $7205
#define PopUp2Item6 $7206
#define PopUp2Item7 $7207
#define PopUp2Item8 $7208
#define PopUp2Item9 $7209

resource rWindParam1 (PopUpWindow) {
 fTitle+fMove+fZoom+fGrow+fBScroll+fRScroll+fClose, /* Frame Bits */
 PopUpWindow, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {400,640}, /* data size */
 {200,640}, /* max height-width */
 {1,1}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {50,50,120,260}, /* window Position */
 infront, /* wPlane */
 PopUpWindow, /* Control Ref */
 refIsResource*0x0100+resourceToResource /* descriptor */
};



resource rpString (PopUpWindow) {
 "PopUps Window"
};


resource rControlList (PopUpWindow) {
 {
 PopUpTextID,
 PopUp1,
 PopUp2
 };
};

/* Template for static text in main window */
resource rControlTemplate (PopUpTextID) {
 PopUpTextID, /* control ID */
 {2,4,48,460}, /* control rectangle */
 StatTextControl{{ /* control type */
 0xFF00, /* flag */
 0x1002, /* more flags */
 0, /* ref con */
 PopUpTextID /* title ref */
 }};
};

/* The static text for list window */
resource rTextForLETextBox2 (PopUpTextID) {
 "This window contains two pop up menus. The first menu has three items and "
 "is constrained to pop up inside the window. The second has nine items and "
 "can pop up outside the window. The first pop-up is a type 1 pop-up while "
 "the second is a type 2."
};



resource rControlTemplate (PopUp1) {
 PopUpTextID, /* control ID */
 {50,50,0,0}, /* control rectangle */
 PopUpControl{{ /* control type */
 fInWindowOnly, /* flags */
 fctlProcNotPtr+RefIsResource, /* MoreFlags */
 0, /* RefCon */
 0, /* Title Width */
 PopUp1, /* Menu ref */
 PopUp1Item1 /* Initial Value */
 }}
};



resource rMenu (PopUp1) {
 PopUp1,	/* id of menu */
 RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache, /* menu flags */
 PopUp1,	/* id of title string */
 { PopUp1Item1,PopUp1Item2,PopUp1Item3 }; /* id's of items */
};

resource rPString (PopUp1) {
 "Pop-up One "
};


resource rMenuItem (PopUp1Item1) {
 PopUp1Item1,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+fXOR,
 PopUp1Item1
};
resource rPString (PopUp1Item1) {
 "Pop-up One: Item 1"
};


resource rMenuItem (PopUp1Item2) {
 PopUp1Item2,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+fXOR,
 PopUp1Item2
};
resource rPString (PopUp1Item2) {
 "Pop-up One: Item 2"
};


resource rMenuItem (PopUp1Item3) {
 PopUp1Item3,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+fXOR,
 PopUp1Item3
};
resource rPString (PopUp1Item3) {
 "Pop-up One: Item 3"
};




resource rControlTemplate (PopUp2) {
 PopUp2, /* control ID */
 {80,50,0,0}, /* control rectangle */
 PopUpControl{{ /* control type */
 fType2PopUp, /* flags */
 fctlProcNotPtr+RefIsResource, /* MoreFlags */
 0, /* RefCon */
 0, /* Title Width */
 PopUp2, /* Menu ref */
 PopUp2Item1 /* Initial Value */
 }}
};




resource rMenu (PopUp2) {
 PopUp2,	/* id of menu */
 RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache, /* menu flags */
 PopUp2,	/* id of title string */
 { PopUp2Item1,
 PopUp2Item2,
 PopUp2Item3,
 PopUp2Item4,
 Popup2Item5,
 Popup2Item6,
 Popup2Item7,
 Popup2Item8,
 Popup2Item9
 }; /* id's of items */
};

resource rPString (PopUp2) {
 "Pop-up Two "
};


resource rMenuItem (PopUp2Item1) {
 PopUp2Item1,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+fXOR,
 PopUp2Item1
};
resource rPString (PopUp2Item1) {
 "Pop-up Two: Item 1"
};


resource rMenuItem (PopUp2Item2) {
 PopUp2Item2,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+fXOR,
 PopUp2Item2
};
resource rPString (PopUp2Item2) {
 "Pop-up Two: Item 2"
};


resource rMenuItem (PopUp2Item3) {
 PopUp2Item3,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+fXOR,
 PopUp2Item3
};
resource rPString (PopUp2Item3) {
 "Pop-up Two: Item 3"
};

resource rMenuItem (PopUp2Item4) {
 PopUp2Item4,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+fXOR,
 PopUp2Item4
};
resource rPString (PopUp2Item4) {
 "Pop-up Two: Item 4"
};

resource rMenuItem (PopUp2Item5) {
 PopUp2Item5,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+fXOR,
 PopUp2Item5
};
resource rPString (PopUp2Item5) {
 "Pop-up Two: Item 5"
};

resource rMenuItem (PopUp2Item6) {
 PopUp2Item6,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+fXOR,
 PopUp2Item6
};
resource rPString (PopUp2Item6) {
 "Pop-up Two: Item 6"
};

resource rMenuItem (PopUp2Item7) {
 PopUp2Item7,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+fXOR,
 PopUp2Item7
};
resource rPString (PopUp2Item7) {
 "Pop-up Two: Item 7"
};

resource rMenuItem (PopUp2Item8) {
 PopUp2Item8,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+fXOR,
 PopUp2Item8
};
resource rPString (PopUp2Item8) {
 "Pop-up Two: Item 8"
};

resource rMenuItem (PopUp2Item9) {
 PopUp2Item9,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+fXOR,
 PopUp2Item9
};
resource rPString (PopUp2Item9) {
 "Pop-up Two: Item 9"
};



/*---------------------------------------------------------------------------*/
/*
/* TextEdits...
/*
/* The textedit window uses ID's in the $8000 range.
/*
/*---------------------------------------------------------------------------*/

#define TextEditTextID $8001
#define TextEdit1 $8002
#define TextEdit2 $8003

resource rWindParam1 (TextEditWindow) {
 fTitle+fMove+fZoom+fGrow+fBScroll+fRScroll+fClose, /* Frame Bits */
 TextEditWindow, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {400,640}, /* data size */
 {200,640}, /* max height-width */
 {1,1}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {50,50,120,260}, /* window Position */
 infront, /* wPlane */
 TextEditWindow, /* Control Ref */
 refIsResource*0x0100+resourceToResource /* descriptor */
};



resource rpString (TextEditWindow) {
 "TextEdits Window"
};


resource rControlList (TextEditWindow) {
 {
 TextEditTextID,
 TextEdit2,
 TextEdit1
 };
};

/* Template for static text in main window */
resource rControlTemplate (TextEditTextID) {
 TextEditTextID, /* control ID */
 {2,4,48,460}, /* control rectangle */
 StatTextControl{{ /* control type */
 0xFF00, /* flag */
 0x1002, /* more flags */
 0, /* ref con */
 TextEditTextID /* title ref */
 }};
};



/* The static text for list window */
resource rTextForLETextBox2 (TextEditTextID) {
 "Two text edit fields."
};


resource rControlTemplate (TextEdit1) {
 TextEdit1, /* control ID */
 {50,4,100,460}, /* control rectangle */
 EditTextControl{{ /* control type */
 0x0000, /* flag */
 fCtlCanBeTarget+fCtlWantsEvents+fctlProcNotPtr, /* more flags */
 0, /* ref con */
 fSmartCutPaste+fTabSwitch+fDrawBounds, /* text flags */
 {0xFFFF,0xFFFF,0xFFFF,0xFFFF}, /* indent rect */
 0xFFFFFFFF, /* Vert Bar */
 0, /* Vert Amount */
 0, /* hor bar */
 0, /* hor Amount */
 0, /* style ref */
 dataIsPString+RefIsResource*8, /* text descriptor */
 TextEdit1, /* text ref */
 0 /* text length */

 }};
};


resource rPString (TextEdit1) {
 "This is a pString that you can edit."
};

resource rCString (TextEdit1) {
 "This is a cstring that you can edit."
};

resource rText (TextEdit1) {
 "This is a text block you can edit."
};


resource rControlTemplate (TextEdit2) {
 TextEdit1, /* control ID */
 {110,4,150,460}, /* control rectangle */
 EditTextControl{{ /* control type */
 0x0000, /* flag */
 fCtlCanBeTarget+fCtlWantsEvents+fctlProcNotPtr, /* more flags */
 0, /* ref con */
 fSmartCutPaste+fTabSwitch+fDrawBounds, /* text flags */
 {0xFFFF,0xFFFF,0xFFFF,0xFFFF}, /* indent rect */
 0xFFFFFFFF, /* Vert Bar */
 0, /* Vert Amount */
 0, /* hor bar */
 0, /* hor Amount */
 0, /* style ref */
 dataIsTextBlock+RefIsResource*8, /* text descriptor */
 TextEdit2, /* text ref */
 0 /* text length */



 }};
};


/* The static text for list window */
resource rText (TextEdit2) {
 "More text. Will it tab?"
};



/*---------------------------------------------------------------------------*/
/*
/* Lists...
/*
/* The List window uses ID's in the $9000 range.
/*
/*---------------------------------------------------------------------------*/

resource rWindParam1 (ListWindow) {
 fTitle+fMove+fZoom+fGrow+fBScroll+fRScroll+fClose, /* Frame Bits */
 ListWindow, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {400,640}, /* data size */
 {200,640}, /* max height-width */
 {1,1}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {50,50,120,260}, /* window Position */
 infront, /* wPlane */
 ListWindow, /* Control Ref */
 refIsResource*0x0100+resourceToResource /* descriptor */
};



resource rpString (ListWindow) {
 "Lists Window"
};


#define ListID $9000
#define ListTextID $9001

/* List of all controls in Main Window */

resource rControlList (ListWindow) {
 {
 ListID,
 ListTextID
 };
};

/* Template for static text in main window */
resource rControlTemplate (ListTextID) {
 ListTextID, /* control ID */
 {2,4,48,460}, /* control rectangle */
 StatTextControl{{ /* control type */
 0xFF00, /* flag */
 0x1002, /* more flags */
 0, /* ref con */
 ListTextID, /* title ref */
 0 /* text size (not used) */
 }};
};

/* The static text for list window */
resource rTextForLETextBox2 (ListTextID) {
 "This list is defined and contained entirely in resources. "
 "The strings in the list are also resources."
};
resource rControlTemplate (ListID) {
 ListID, /* Control ID */
 {50,50,152,350}, /* list rectangle */
 ListControl{{ /* list type */
 0, /* flag */
 0x1002, /* more flags */
 0, /* ref con */
 16, /* Num Members in list */
 0, /* list view (let list mgr calc) */
 0, /* List type */
 1, /* list start (start at top ) */
 10, /* ListMemHeight */
 5, /* ListMemSize */
 ListID /* ListRef (ID of list record) */
 }};
};

resource rListRef (ListID) {
 { 0x9001,memNormal,
 0x9002,memSelected,
 0x9003,memDisabled,
 0x9004,memNormal,
 0x9005,memNormal,
 0x9006,memNormal,
 0x9007,memNormal,
 0x9008,memNormal,
 0x9009,memNormal,
 0x900A,memNormal,
 0x900B,memNormal,
 0x900C,memNormal,
 0x900D,memNormal,
 0x900E,memNormal,
 0x900F,memNormal,
 0x9010,memNormal
 };
};


resource rpString (0x9001) {
 "Item One"
};
resource rpString (0x9002) {
 "Item Two"
};
resource rpString (0x9003) {
 "Item Three"
};
resource rpString (0x9004) {
 "Item Four"
};
resource rpString (0x9005) {
 "Item Five"
};
resource rpString (0x9006) {
 "Item Six"
};
resource rpString (0x9007) {
 "Item Seven"
};
resource rpString (0x9008) {
 "Item Eight"
};
resource rpString (0x9009) {
 "Item Nine"
};
resource rpString (0x900A) {
 "Item Ten"
};
resource rpString (0x900B) {
 "Item Eleven"
};
resource rpString (0x900C) {
 "Item Twelve"
};
resource rpString (0x900D) {
 "Item Thirteen"
};
resource rpString (0x900E) {
 "Item Fourteen"
};
resource rpString (0x900F) {
 "Item Fifteen"
};
resource rpString (0x9010) {
 "Item Sixteen"
};







/*********************************************************************/
/*
/* Menus
/*
/*********************************************************************/

#define AppleMenuID $1100
#define FileMenuID $1200
#define EditMenuID $1300

#define AboutID $1101

#define CloseID 255
#define QuitID $1202


#define UndoID 250
#define CutID 251
#define CopyID 252
#define PasteID 253
#define ClearID 254



resource rMenuBar ($1000) {
 {
 AppleMenuID,
 FileMenuID,
 EditMenuID,
 };
};

resource rMenu (AppleMenuID) {
 AppleMenuID,
 0xA008,
 AppleMenuID,
 { AboutID };
};

resource rMenu (FileMenuID) {
 FileMenuID,
 0xA008,
 FileMenuID,
 { CloseID,
 QuitID };
};

resource rMenu (EditMenuID) {
 EditMenuID,
 0xA008,
 EditMenuID,
 {
 UndoID,
 CutID,
 CopyID,
 PasteID,
 ClearID
 };
 };

resource rMenuItem (AboutID) {
 AboutID,
 "","",
 0,
 0x8040,
 AboutID
};

resource rMenuItem (UndoID) {
 UndoID,
 "","",
 0,
 0x8000,
 UndoID
};

resource rMenuItem (CutID) {
 CutID,
 "X","x",
 0,
 0x8000,
 CutID
};

resource rMenuItem (CopyID) {
 CopyID,
 "C","c",
 0,
 0x8000,
 CopyID
};

resource rMenuItem (PasteID) {
 PasteID,
 "V","v",
 0,
 0x8000,
 PasteID
};

resource rMenuItem (ClearID) {
 ClearID,
 "","",
 0,
 0x8000,
 ClearID
};

resource rMenuItem (CloseID) {
 CloseID,
 "W","w",
 0,
 0x8000,
 CloseID
};

resource rMenuItem (QuitID) {
 QuitID,
 "Q","q",
 0,
 0x8000,
 QuitID
};


resource rPString (AppleMenuID) {
 "@"
 };
resource rPString (FileMenuID) {
 " File "
 };
resource rPString (EditMenuID) {
 " Edit "
 };
resource rPString (AboutID) {
 "About BusyBox..."
 };
resource rPString (CloseID) {
 "Close"
 };
resource rPString (UndoID) {
 "Undo"
 };
resource rPString (CutID) {
 "Cut"
 };
resource rPString (CopyID) {
 "Copy"
 };
resource rPString (PasteID) {
 "Paste"
 };
resource rPString (ClearID) {
 "Clear"
 };
resource rPString (QuitID) {
 "Quit"
 };













/*---------------------------------------------------------------------------*/
/*
/* Program...
/*
/* The program windows use ID's in the $A000 range
/*
/*---------------------------------------------------------------------------*/

#define Program1 $A001
#define Program2 $A002
#define Program3 $A003
#define Program4 $A004
#define Program5 $A005
#define Program6 $A006

resource rWindParam1 (Prog1Window) {
 fTitle+fMove+fZoom+fClose, /* Frame Bits */
 Prog1Window, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {400,640}, /* data size */
 {200,640}, /* max height-width */
 {1,1}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {30,4,180,500}, /* window Position */
 infront, /* wPlane */
 Program1, /* Control Ref */
 refIsResource*0x0100+refIsResource /* descriptor */
};



resource rpString (Prog1Window) {
 "Main Program"
};


resource rControlList (Program1) {
 {
 Program1
 };
};


resource rControlTemplate (Program1) {
 TextEdit1, /* control ID */
 {0,0,0,0}, /* control rectangle */
 EditTextControl{{ /* control type */
 0x0000, /* flag */
 fCtlCanBeTarget+fCtlWantsEvents+fctlProcNotPtr+fctlTellAboutSize, /* more flags */
 0, /* ref con */
 fReadOnly+fNoWordWrap, /* text flags */
 {0xFFFF,0xFFFF,0xFFFF,0xFFFF}, /* indent rect */
 0xFFFFFFFF, /* Vert Bar */
 0, /* Vert Amount */
 0, /* hor bar */
 0, /* hor Amount */
 0, /* style ref */
 dataIsTextBlock+RefIsResource*8, /* text descriptor */
 Program1, /* text ref */
 0 /* text length */



 }};
};

read rText (Program1) "busy.aii";


resource rWindParam1 (Prog2Window) {
 fTitle+fMove+fZoom+fClose, /* Frame Bits */
 Prog2Window, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {400,640}, /* data size */
 {200,640}, /* max height-width */
 {1,1}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {30,4,180,500}, /* window Position */
 infront, /* wPlane */
 Program2, /* Control Ref */
 refIsResource*0x0100+refIsResource /* descriptor */
};



resource rpString (Prog2Window) {
 "Event Unit"
};


resource rControlList (Program2) {
 {
 Program2
 };
};


resource rControlTemplate (Program2) {
 Program2, /* control ID */
 {0,0,0,0}, /* control rectangle */
 EditTextControl{{ /* control type */
 0x0000, /* flag */
 fCtlCanBeTarget+fCtlWantsEvents+fctlProcNotPtr+fctlTellAboutSize, /* more flags */
 0, /* ref con */
 fReadOnly+fNoWordWrap, /* text flags */
 {0xFFFF,0xFFFF,0xFFFF,0xFFFF}, /* indent rect */
 0xFFFFFFFF, /* Vert Bar */
 0, /* Vert Amount */
 0, /* hor bar */
 0, /* hor Amount */
 0, /* style ref */
 dataIsTextBlock+RefIsResource*8, /* text descriptor */
 Program2, /* text ref */
 0 /* text length */

 }};
};

read rText (Program2) "uevent.aii";


resource rWindParam1 (Prog3Window) {
 fTitle+fMove+fZoom+fClose, /* Frame Bits */
 Prog3Window, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {400,640}, /* data size */
 {200,640}, /* max height-width */
 {1,1}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {30,4,180,500}, /* window Position */
 infront, /* wPlane */
 Program3, /* Control Ref */
 refIsResource*0x0100+refIsResource /* descriptor */
};



resource rpString (Prog3Window) {
 "Menu Unit"
};


resource rControlList (Program3) {
 {
 Program3
 };
};


resource rControlTemplate (Program3) {
 Program3, /* control ID */
 {0,0,0,0}, /* control rectangle */
 EditTextControl{{ /* control type */
 0x0000, /* flag */
 fCtlCanBeTarget+fCtlWantsEvents+fctlProcNotPtr+fctlTellAboutSize, /* more flags */
 0, /* ref con */
 fReadOnly+fNoWordWrap, /* text flags */
 {0xFFFF,0xFFFF,0xFFFF,0xFFFF}, /* indent rect */
 0xFFFFFFFF, /* Vert Bar */
 0, /* Vert Amount */
 0, /* hor bar */
 0, /* hor Amount */
 0, /* style ref */
 dataIsTextBlock+RefIsResource*8, /* text descriptor */
 Program3, /* text ref */
 0 /* text length */

 }};
};

read rText (Program3) "umenu.aii";


resource rWindParam1 (Prog4Window) {
 fTitle+fMove+fZoom+fClose, /* Frame Bits */
 Prog4Window, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {400,640}, /* data size */
 {200,640}, /* max height-width */
 {1,1}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {30,4,180,500}, /* window Position */
 infront, /* wPlane */
 Program4, /* Control Ref */
 refIsResource*0x0100+refIsResource /* descriptor */
};



resource rpString (Prog4Window) {
 "Window Unit"
};


resource rControlList (Program4) {
 {
 Program4
 };
};


resource rControlTemplate (Program4) {
 Program4, /* control ID */
 {0,0,0,0}, /* control rectangle */
 EditTextControl{{ /* control type */
 0x0000, /* flag */
 fCtlCanBeTarget+fCtlWantsEvents+fctlProcNotPtr+fctlTellAboutSize, /* more flags */
 0, /* ref con */
 fReadOnly+fNoWordWrap, /* text flags */
 {0xFFFF,0xFFFF,0xFFFF,0xFFFF}, /* indent rect */
 0xFFFFFFFF, /* Vert Bar */
 0, /* Vert Amount */
 0, /* hor bar */
 0, /* hor Amount */
 0, /* style ref */
 dataIsTextBlock+RefIsResource*8, /* text descriptor */
 Program4, /* text ref */
 0 /* text length */

 }};
};

read rText (Program4) "uwindow.aii";


resource rWindParam1 (Prog5Window) {
 fTitle+fMove+fZoom+fClose, /* Frame Bits */
 Prog5Window, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {400,640}, /* data size */
 {200,640}, /* max height-width */
 {1,1}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {30,4,180,500}, /* window Position */
 infront, /* wPlane */
 Program5, /* Control Ref */
 refIsResource*0x0100+refIsResource /* descriptor */
};



resource rpString (Prog5Window) {
 "Utility Unit"
};


resource rControlList (Program5) {
 {
 Program5
 };
};


resource rControlTemplate (Program5) {
 Program5, /* control ID */
 {0,0,0,0}, /* control rectangle */
 EditTextControl{{ /* control type */
 0x0000, /* flag */
 fCtlCanBeTarget+fCtlWantsEvents+fctlProcNotPtr+fctlTellAboutSize, /* more flags */
 0, /* ref con */
 fReadOnly+fNoWordWrap, /* text flags */
 {0xFFFF,0xFFFF,0xFFFF,0xFFFF}, /* indent rect */
 0xFFFFFFFF, /* Vert Bar */
 0, /* Vert Amount */
 0, /* hor bar */
 0, /* hor Amount */
 0, /* style ref */
 dataIsTextBlock+RefIsResource*8, /* text descriptor */
 Program5, /* text ref */
 0 /* text length */

 }};
};

read rText (Program5) "uutils.aii";


resource rWindParam1 (Prog6Window) {
 fTitle+fMove+fZoom+fClose, /* Frame Bits */
 Prog6Window, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {400,640}, /* data size */
 {200,640}, /* max height-width */
 {1,1}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {30,4,180,500}, /* window Position */
 infront, /* wPlane */
 Program6, /* Control Ref */
 refIsResource*0x0100+refIsResource /* descriptor */
};



resource rpString (Prog6Window) {
 "Globals Unit"
};


resource rControlList (Program6) {
 {
 Program6
 };
};


resource rControlTemplate (Program6) {
 Program6, /* control ID */
 {0,0,0,0}, /* control rectangle */
 EditTextControl{{ /* control type */
 0x0000, /* flag */
 fCtlCanBeTarget+fCtlWantsEvents+fctlProcNotPtr+fctlTellAboutSize, /* more flags */
 0, /* ref con */
 fReadOnly+fNoWordWrap, /* text flags */
 {0xFFFF,0xFFFF,0xFFFF,0xFFFF}, /* indent rect */
 0xFFFFFFFF, /* Vert Bar */
 0, /* Vert Amount */
 0, /* hor bar */
 0, /* hor Amount */
 0, /* style ref */
 dataIsTextBlock+RefIsResource*8, /* text descriptor */
 Program6, /* text ref */
 0 /* text length */

 }};
};

read rText (Program6) "uglobals.aii";
